' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

Partial Class SiteMenu
  Inherits System.Web.UI.UserControl

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    ' The ItemDataBound methods take care of preselecting databound items.
    ' However, we also need to cater fot the Home, Admin and Login items
    If Request.AppRelativeCurrentExecutionFilePath.ToLower() = "~/default.aspx" Then
      liHome.Attributes("class") = "Selected"
    End If
    If Request.AppRelativeCurrentExecutionFilePath.ToLower().Contains("/management/") Then
      liManagement.Attributes("class") = "Selected"
    End If
    If Request.AppRelativeCurrentExecutionFilePath.ToLower() = "~/login.aspx" Then
      liLogin.Attributes("class") = "Selected"
    End If
  End Sub

  Protected Sub sdsSubMenu_Selected(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.SqlDataSourceStatusEventArgs) Handles sdsSubMenu.Selected
    ' Hide the sub menu when there are no categories for the chosen content type.
    If e.AffectedRows = 0 Then
      repSubMenu.Visible = False
    End If
  End Sub

  Protected Sub repMainMenu_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.RepeaterItemEventArgs) Handles repMainMenu.ItemDataBound
    If e.Item.ItemType = ListItemType.Item Or e.Item.ItemType = ListItemType.AlternatingItem Then
      Dim myDataRowView As DataRowView = DirectCast(e.Item.DataItem, DataRowView)
      If Convert.ToInt32(myDataRowView("Id")) = Convert.ToInt32(Request.QueryString.Get("ContentTypeId")) Then
        Dim lnkMainMenu As HtmlGenericControl = DirectCast(e.Item.FindControl("liMainMenuItem"), HtmlGenericControl)
        lnkMainMenu.Attributes("class") = "Selected"
      End If
    End If
  End Sub

  Protected Sub repSubMenu_ItemDataBound(ByVal sender As Object, _
        ByVal e As System.Web.UI.WebControls.RepeaterItemEventArgs) _
        Handles repSubMenu.ItemDataBound
    If e.Item.ItemType = ListItemType.Item Or _
        e.Item.ItemType = ListItemType.AlternatingItem Then
      Dim myDataRowView As DataRowView = DirectCast(e.Item.DataItem, DataRowView)
      If Convert.ToInt32(myDataRowView("Id")) = _
            Convert.ToInt32(Request.QueryString.Get("CategoryId")) Then
        Dim lnkSubmenu As HyperLink = _
            DirectCast(e.Item.FindControl("lnkSubmenu"), HyperLink)
        lnkSubmenu.CssClass = "Selected"
      End If
    End If
  End Sub
End Class
